﻿using System;
using System.Collections.Generic;
using System.Windows.Forms;
using System.Globalization;
using SautinSoft.Document;

namespace CarRental
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            comboFormat.SelectedIndex = 0;


            // Some Bonus, autocomplite date

            // Year
            tbYear.Text = DateTime.Now.Year.ToString();

            // Month
            CultureInfo ci = new CultureInfo("en-US");
            tbMonth.Text = ci.DateTimeFormat.GetMonthName(DateTime.Now.Month);

            // Day
            tbDay.Text = DateTime.Now.Day.ToString();
        }

        private void btnRun_Click(object sender, EventArgs e)
        {
            DocumentCore.Serial = "11419620241";

            // Templates <Template Name, Path to a template file>.
            Dictionary<string, string> templateCollection = new Dictionary<string, string>();

            if (chkCarContract.Checked)
                templateCollection.Add("CarRentalContract", @"d:\car-rental-template.docx");

            if (chkInsurance.Checked)
                templateCollection.Add("InsurancePolicy", @"d:\insurance-template.docx");

            // Create dataSource
            var dataSource = new 
            {
                RenterName = tbRenterName.Text,
                RenterAddress = tbRenterAddress.Text,
                RenterPhone = tbRenterPhone.Text,
                CarModel = tbCarModel.Text,
                CarVIN = tbCarVIN.Text,
                CarMileage = tbCarMileage.Text,
                Period = tbPeriod.Text,
                Day = tbDay.Text,
                Month = tbMonth.Text,
                Year = tbYear.Text
            };

            foreach (KeyValuePair<string, string> template in templateCollection)
            {
                // template.Value - contains a path to template file.
                // For example, "d:\car-rental-template.docx"
                DocumentCore dc = DocumentCore.Load(template.Value);

                // Do Mail Merge
                // Import data to the template.
                dc.MailMerge.Execute(dataSource);


                // Save the ready document

                // Specify extension for the ready document
                string ext = comboFormat.Text;

                // template.Key - contains a name of our ready document                
                // For example, if RenterName is "John", as result we get: "CarRentalContract-John.pdf".
                string readyDocPath = String.Format("{0}-{1}{2}", template.Key, dataSource.RenterName, ext);

                // The file format is detected automatically from the file extension.
                dc.Save(readyDocPath);

                // Open the ready document for demonstration purposes.
                System.Diagnostics.Process.Start(readyDocPath);
            }
        }
    }
}
